(function($) {
  "use strict";



    // mobile menu
  $("#mobile-menu").meanmenu({
    meanMenuContainer: ".mobile-menu",
    meanScreenWidth: "991"
  });

  // offcanvas menu
  $(".menu-tigger").on("click", function() {
    $(".offcanvas-menu,.offcanvas-overly").addClass("active");
    return false;
  });
  $(".menu-close,.offcanvas-overly").on("click", function() {
    $(".offcanvas-menu,.offcanvas-overly").removeClass("active");
  });


    function toggleIcon(e) {
        $(e.target)
            .prev('.card-header')
            .find(".more-less")
            .toggleClass('fa-plus fa-minus');
    }
    $('#accordion').on('hidden.bs.collapse', toggleIcon);
    $('#accordion').on('shown.bs.collapse', toggleIcon);

  //   Slider activation

  function mainSlider() {
    var BasicSlider = $(".slider-active");
    BasicSlider.on("init", function(e, slick) {
      var $firstAnimatingElements = $(".single-slider:first-child").find(
        "[data-animation]"
      );
      doAnimations($firstAnimatingElements);
    });
    BasicSlider.on("beforeChange", function(e, slick, currentSlide, nextSlide) {
      var $animatingElements = $(
        '.single-slider[data-slick-index="' + nextSlide + '"]'
      ).find("[data-animation]");
      doAnimations($animatingElements);
    });
    BasicSlider.slick({
      autoplay: true,
      autoplaySpeed: 10000,
      fade: true,
      prevArrow:
        '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
      nextArrow:
        '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
      arrows: false,
      dots: true,
      responsive: [
        { breakpoint: 767, settings: { dots: true, arrows: false } }
      ]
    });

    function doAnimations(elements) {
      var animationEndEvents =
        "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
      elements.each(function() {
        var $this = $(this);
        var $animationDelay = $this.data("delay");
        var $animationType = "animated " + $this.data("animation");
        $this.css({
          "animation-delay": $animationDelay,
          "-webkit-animation-delay": $animationDelay
        });
        $this.addClass($animationType).one(animationEndEvents, function() {
          $this.removeClass($animationType);
        });
      });
    }
  }
  mainSlider();

  // slider-three
  $(".slider-three-active").slick({
    infinite: true,
    autoplay: false,
    autoplaySpeed: 5000,
    speed: 400,
    dots: false,
    slidesToShow: 1,
    slidesToScroll: 1,
    prevArrow:
      '<button type="button" class="slick-prev"><span class="lnr lnr-chevron-left"></span></button>',
    nextArrow:
      '<button type="button" class="slick-next"><span class="lnr lnr-chevron-right"></span></button>',
    arrows: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          infinite: true,
          dots: false
        }
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          infinite: true,
          dots: false,
          arrows: false
        }
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          infinite: true,
          dots: false,
          arrows: false
        }
      }
    ]
  });




  // testimonial

  $("#estrutura-inicial").owlCarousel({
    loop: true,
    margin: 10,
    nav: true,
    dots: true,
    responsive: {
      0: {
        items: 1
      },
      600: {
        items: 2
      },
      1000: {
        items: 3
      },
      1200: {
        items: 5
      }
    }
  });

    $("#contatoBtn").on("click", function () {
        $("#contatoForm").validate({
            rules: {
                nome: {
                    required: true
                },
                cidade: {
                    required: true
                },
                telefone: {
                    required: true
                },
                email: {
                    required: true,
                    email: true
                },
                assunto: {
                    required: true
                },
                mensagem: {
                    required: true
                }

            },
            messages: {
                nome: {
                    required: "Informe o seu nome"
                },
                cidade: {
                    required: "Informe o sua cidade"
                },
                telefone: {
                    required: "Informe o seu telefone"
                },
                email: {
                    required: "Informe o seu e-mail",
                    email: "Informe um e-mail válido"
                },
                assunto: {
                    required: "Informe o assunto"
                },
                mensagem: {
                    required: "Informe a mensagem"
                }
            },
            submitHandler: function submitHandler(form, event) {
                $("#contatoBtn").prop("disabled", true);
                $("#contatoBtn").text("Enviando...");
                event.preventDefault();
                $.ajax({
                    type: "POST",
                    data: {
                        nome: form.nome.value,
                        telefone: form.telefone.value,
                        cidade: form.cidade.value,
                        email: form.email.value,
                        mensagem: form.mensagem.value
                    },
                    url: dominio + "/site/contato_enviar.php",
                    success: function success() {
                        $.alert("Mensagem enviada com sucesso!");
                        $("#contatoForm")[0].reset();

                        console.log("Mensagem enviada com sucesso!");
                        $("#contatoBtn").prop("disabled", false);
                        $("#contatoBtn").text("Enviar");
                    },
                    error: function error() {
                        $.alert("Ocorreu um erro. Tente novamente mais tarde");

                        $("#contatoBtn").prop("disabled", false);
                        $("#contatoBtn").text("Enviar");
                    }
                });
            }
        });
    });




    $(document).swipebox({selector: '.swipebox'});
    $('#gallery').click(function (e) {
        e.preventDefault();
    });



})(jQuery);
